﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;

//using System.Globalization;
//using System.Threading;

public partial class TBI_Referrals : BasePage
{
    private TBI_REFERRAL referral;
    private TBIReferralManager referralManager = new TBIReferralManager();
    private bool EnforceRulesOnPreRender = true;

    public TBI_Referrals()
    {
        //Manager Save Notification Event Handler
        referralManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }
    public override string MenuItemName()
    {
        return "TBI REFERRAL";
    }
    public override string AppObjectCode()
    {
        return "TBI REFERRAL";
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            
            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? referralId = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldReferralID.Value = referralId.GetValueOrDefault().ToString();

            RangeValidatorTextBoxDateEvaluationCompleted.MaximumValue = 
            RangeValidatorTextBoxDateConsultReferral.MaximumValue = DateTime.Today.ToShortDateString();

        }
            
        //Create Referral object and Set properties to state of form
        getReferral(Convert.ToInt32(HiddenFieldReferralID.Value));


        if (!IsPostBack)
        {
            AddReferralInformationToBreadCrumb();

        }

        //load TBI diagnosis dropdown 
        if (!IsPostBack)
        {
            if (referral != null)
            {
                var items = new[] { new ListItem("Yes", "1"), new ListItem("No", "2"), new ListItem("Uncertain", "3") };

                Func<ListItem, bool> condition = item =>
                {                    
                        if (int.Parse(item.Value) == 3)
                        {
                            if (referral.WKF_CASEs[0].TBI_TRACKINGs[0].TBI_DIAGNOSIS_IND.HasValue)
                            {
                                return (int.Parse(referral.WKF_CASEs[0].TBI_TRACKINGs[0].TBI_DIAGNOSIS_IND.ToString()) == 3);
                                                                   
                            }
                            else
                            {    
                                return false;
                            }
                        }
                        else
                        {
                            return true;

                        }                 
                                               
                };

                DropDownListDefinitiveTBIDiagnosis.Items.AddRange(items.Where(condition).ToArray());
            
            }
                            
        }
        if (IsPostBack)
        {
            LoadObjectFromControls();
        }
    }

    private void AddReferralInformationToBreadCrumb()
    {
        LabelBreadCrumb.Text = LabelBreadCrumb.Text + " > " + referral.STD_REFERRALST.NAME + " > Edit Referral ID : " + referral.REFERRAL_ID;
    }

    protected void getReferral(int id)
    {
        //initial display panels
        PanelNoAccess.Visible = false;
        PanelReferralIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        referral = referralManager.SelectByID(id);
        if (referral == null)
        {
            PanelObjectContent.Visible = false;

            if (referralManager.ReferralExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelReferralIdNotFound.Visible = true;
            }
        }
        else
        {
            EntityInstitution = referral.STD_INSTITUTION_ID;
            PanelObjectContent.Visible = true;
        }
    }
    void Page_PreRender(object sender, EventArgs e)
    {
        if (referral != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object
            
            //Enforce business rules on the referral object
                //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
                //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack && EnforceRulesOnPreRender)
            {
                int ret;
                ret = referralManager.EnforceBusinessRules(ref referral);
            }

            LoadControlsFromObject();
        }

        if (this.AllowUpdate)
        {
            ButtonSave.Visible = true;
        }
        else
        {
            ButtonSave.Visible = false;
        }

        if (this.ReadOnly)
        {
            MakeFormReadOnly(AppObjectCode(), this.Controls);
            FormIsReadOnly.Value = "1";
        }
        else 
        {
            FormIsReadOnly.Value = "0";
        }
    }

    #region Postback Events
    
    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        Validate("OnSave");

        if (Page.IsValid)
        {
            SaveReferral();
            RefreshLeftMenu();
        }
    }

    private void SaveReferral()
    {
        int returnValue = referralManager.Update(referral);
        this.SuppressSaveMessage = false;

        ErrorList1.BrokenRules = referral.BrokenRules;

        if ( returnValue > 0 )
        {
            IsSaveSuccess = true;

            ((HiddenField)this.Master.FindControl("HiddenFieldShowSaveMessage")).Value = "true";
            HiddenFieldDisplaySaveErrorList.Value = "false";
            ErrorList1.Visible = false;

            //Fortify errors on this line (this.Master as RegistryMaster).SetDirtyFlag(false);
            ((RegistryMaster)Master).SetDirtyFlag(false);
        }
        else
        {
            IsSaveSuccess = false;

            //Display Error Message
            ErrorList1.Visible = true;
            HiddenFieldDisplaySaveErrorList.Value = "true";
        }
    }

    protected void        ButtonComplete_Click(object sender, EventArgs e)
    {
        int returnSaveValue;

        //Status
        referral.STD_REFERRALST = 
            referralManager.getNewReferralStatus((int)TBI_REFERRAL.TbiReferralStatus.Completed);

        int ret;
        ret = referralManager.EnforceBusinessRules(ref referral);

        //To Do: set the validators to enabled
        LoadControlsFromObject();

        Validate();

        if (Page.IsValid)
        {
            SaveReferral();
            RefreshLeftMenu();

        }
        else 
        {
            //Status
            referral.STD_REFERRALST =
                referralManager.getNewReferralStatus((int)TBI_REFERRAL.TbiReferralStatus.InProcess);

            EnforceRulesOnPreRender = false;

            if (!IsValid) // server-side validation failed
            {
                StringBuilder oErrorScript = new StringBuilder();
                string sScript1 = @"<script type=""text/javascript"" language=""JavaScript"">";
                string sScript2a = @" alert('The page has the following data errors:\n";
                string sScript2b = @"')";
                string sScript3 = @"</script>";
                oErrorScript.AppendLine(sScript1);
                oErrorScript.Append(sScript2a);
                ValidatorCollection oValidatorCollection = Validators;
                bool focusIsSet = false;
                foreach (BaseValidator oValidator in oValidatorCollection)
                {
                    if (!oValidator.IsValid)
                    {
                        if (!focusIsSet)
                        {
                            var test = PanelObjectContent.FindControl(oValidator.ControlToValidate);
                            test.Focus();

                            HiddenField hf =
                                (HiddenField) Page.Master.FindControl("focusField");
                            hf.Value = test.ClientID;

                            focusIsSet = true;
                        }

                        string sErrorMessage = "-" + oValidator.ErrorMessage + @"\n";
                        oErrorScript.Append(sErrorMessage);
                    }
                }
                oErrorScript.AppendLine(sScript2b);
                oErrorScript.AppendLine(sScript3);
                
                ClientScript.RegisterStartupScript(this.GetType(),"AlertMessage", oErrorScript.ToString());

                return;
            }
        }
    }

    protected void ButtonReOpen_Click(object sender, EventArgs e)
    {
        //Status
        referral.STD_REFERRALST =
            referralManager.getNewReferralStatus((int)TBI_REFERRAL.TbiReferralStatus.InProcess);

        int ret;
        ret = referralManager.EnforceBusinessRules(ref referral);

        //To Do: set the validators to enabled
        //LoadControlsFromObject();

        SaveReferral();
        RefreshLeftMenu();

        var master = (RegistryMaster)Master;
        master.SetDirtyFlag(false);

        this.ReadOnly = false;

        this.EnableAllControls(this.Controls);
        //Response.Redirect(Request.Url.ToString());
        //Server.Transfer("referral.aspx?id=" + referral.REFERRAL_ID + "&saveStatus=" + this.IsSaveSuccess);
    }

    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("Referrals.aspx");
    }

    private void RefreshLeftMenu()
    {
        //refresh left menu
        //Get menu list based on user access
        string[] pagesAccessibleByUser = ((UserAccountManager)HttpContext.Current.User).GetPagesByCode();

        MenuHorizontalMenu = (Menu)Master.FindControl("MenuHorizontalMenu");
        MenuLeftNavigation = (Menu)Master.FindControl("MenuLeftNavigation");
        LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        MenuLeftNavigation.Items.Clear();

        //Populate left menu and breadcrumb - based on user roles
        MenuBuilder.BuildDynamicNavigationItems(HttpContext.Current.Request.Url.PathAndQuery, MenuHorizontalMenu, TopMenuName(), MenuLeftNavigation, MenuItemName(), LabelBreadCrumb, pagesAccessibleByUser);

        AddReferralInformationToBreadCrumb();
    }


    protected void DropDownListResponsibleTeam_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListResponsibleTeam.SelectedValue == ((int)TBI_REFERRAL.ResponsibleTeamCode.Other).ToString())
        {
            //LabelforTextBoxResponsibleTeamOther.Visible = true;
            //TextBoxResponsibleTeamOther.Visible = true;
            RequiredFieldValidatorResponsibleTeamOther.Enabled = true;

            //ResponsibleTeamOtherRow.Visible = true;
        }
        else
        {
            //LabelforTextBoxResponsibleTeamOther.Visible = false;
            //TextBoxResponsibleTeamOther.Visible = false;
            RequiredFieldValidatorResponsibleTeamOther.Enabled = false;

            //ResponsibleTeamOtherRow.Visible = false;
        }
    }
    #endregion
    #region Object/Form Mapping
    private void LoadObjectFromControls()
    {
        if (referral == null)
        {
            return;
        }
        
        //set a flag in object to denote that the object is being loaded with state changes that occurred in disconnected fashion
        referral.LoadedWithDisconnectedStateChanges = true;

        //Facility:
        //referral.STD_INSTITUTION.STD_INSTITUTION_PARENT.NAME = LabelVamcVisn.Text;
        //referral.STD_INSTITUTION.STATIONNUMBER = LabelVamcStationNumber.Text;
        //referral.STD_INSTITUTION.VISTANAME = LabelVamcVistaName.Text;

        //Name/SS# of Patient with + screen and desiring eval
        //referral.PATIENT.LAST_NAME = LabelPatientLastName.Text;
        //referral.PATIENT.FIRST_NAME = LabelPatientFirstName.Text;
        //referral.PATIENT.MIDDLE_NAME = LabelPatientMiddleName.Text;
        //referral.PATIENT.SSN = LabelPatientSSN.Text;

        //Date of Screening
        //referral.REFERRAL_DATE = Helpers.getNullableDateFromString(TextBoxReferralDate.Text);
        referral.REFERRAL_DATE = Helpers.getNullableDateFromString(LabelReferralDate.Text);
        
        //Date of Consult/Referral
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE = Helpers.getNullableDateFromString(TextBoxDateConsultReferral.Text);
        //referral.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE = Helpers.getNullableDateFromString(DateConsultReferral.DateValue);
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].CONSULT_NOT_APPLICABLE_FLAG = CheckBoxNotApplicable.Checked;
        
        //Other Consult Referral Status
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALST = referralManager.getNewOtherConsultStatus(Helpers.getNullableIntFromString(DropDownListOtherConsultStatus.SelectedValue));

            
        //First Schedule Attempt ----------------------------

        //Attempts to Contact Patient for Scheduling Purposes
        referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[0].STD_TBISCHEDULEST =
            referralManager.getNewTBIScheduleStatus(Helpers.getNullableIntFromString(DropDownListAttempts.SelectedValue));
        
        //Date Scheduled with TBI Evaluation Team
        referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.One].TBI_EVALUATION_SCHEDULE_DATE = 
            Helpers.getNullableDateFromString(TextBoxDateScheduledWithTBIEvaluationTeam.Text);
       
        //Delay in Completing Evaluation
        referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.One].STD_TBIEVALDELAYTYPE = 
            referralManager.getNewTBIEvalDelayTypeStatus(Helpers.getNullableIntFromString(DropDownListDelayCompletingEvaluation.SelectedValue));

        //Second Schedule Attempt ---------------------------
        if (referral.TbiNumberOfNoShows > 0)
        {
            //referral.RuleAddAttemptActivities();
            int ret;
            ret = referralManager.EnforceBusinessRules(ref referral);

            if (referral.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() > 1)
            {

                //Attempts to Contact Patient for Scheduling Purposes
                referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Two].STD_TBISCHEDULEST =
                    referralManager.getNewTBIScheduleStatus(Helpers.getNullableIntFromString(DropDownListSecondContactAttempt.SelectedValue));
                
                //Date Scheduled with TBI Evaluation Team
                referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Two].TBI_EVALUATION_SCHEDULE_DATE =
                    Helpers.getNullableDateFromString(TextBoxDateScheduledTBI1.Text);

                //Delay in Completing Evaluation
                referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Two].STD_TBIEVALDELAYTYPE =
                    referralManager.getNewTBIEvalDelayTypeStatus(Helpers.getNullableIntFromString(DropDownListDelay1.SelectedValue));
            }
        }
       

        //Third Schedule Attempt ---------------------------
        if (referral.TbiNumberOfNoShows > 1)
        {
            //referral.RuleAddAttemptActivities();
            int ret;
            ret = referralManager.EnforceBusinessRules(ref referral);

            if (referral.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() > 2)
            {
                //Attempts to Contact Patient for Scheduling Purposes
                referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Three].STD_TBISCHEDULEST =
                    referralManager.getNewTBIScheduleStatus(Helpers.getNullableIntFromString(DropDownListAttempts2.SelectedValue));

                //Date Scheduled with TBI Evaluation Team
                referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Three].TBI_EVALUATION_SCHEDULE_DATE =
                    Helpers.getNullableDateFromString(TextBoxDateScheduledTBI2.Text);

                //Delay in Completing Evaluation
                referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Three].STD_TBIEVALDELAYTYPE =
                    referralManager.getNewTBIEvalDelayTypeStatus(Helpers.getNullableIntFromString(DropDownListDelay2.SelectedValue));
            }

            if (DropDownListDelay2.SelectedValue == "1" || DropDownListDelay2.SelectedValue == "2")
            {
                TextBoxDateEvaluationCompleted.Text = "";
                RequiredFieldValidatorForTextBoxDateEvaluationCompleted.Enabled = false;

                DropDownListDefinitiveTBIDiagnosis.SelectedIndex = -1;
                RequiredFieldValidatorListDefinitiveTBIDiagnosis.Enabled = false;

                DropDownListResponsibleTeam.SelectedIndex = -1;
                RequiredFieldValidatorResponsibleTeam.Enabled = false;

                LabelTimeToCompleteEvaluation.Text = "";

            }
            else
            {
                RequiredFieldValidatorForTextBoxDateEvaluationCompleted.Enabled = true;
                RequiredFieldValidatorListDefinitiveTBIDiagnosis.Enabled = true;
                RequiredFieldValidatorResponsibleTeam.Enabled = true;

            }
        }
      
        //end attempts

        //Date Evaluation Completed
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_COMPLETE_DATE = 
            Helpers.getNullableDateFromString(TextBoxDateEvaluationCompleted.Text);

        //Definitive TBI Diagnosis
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].TBI_DIAGNOSIS_IND =
            Helpers.getNullableCharFromString(DropDownListDefinitiveTBIDiagnosis.SelectedValue);

        //Responsible TBI Evaluation Team (Service/Clinic)
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBITEAMTYPE =
            referralManager.getNewTBIEvalTeam(Helpers.getNullableIntFromString(DropDownListResponsibleTeam.SelectedValue));

        //Responsible TBI Evaluation Team (Service/Clinic) Other
        referral.WKF_CASEs[0].TBI_TRACKINGs[0].OTHER_TBI_FACILITY_DSCR =
            TextBoxResponsibleTeamOther.Text;
        
        //Status
        //referral.STD_REFERRALST = 
        //    referralManager.getNewReferralStatus(Helpers.getIntFromString(DropDownListReferralStatus.SelectedValue));
        //TODO: add logic to remove schedule attempts if drop down is set to "-- select --"
    }
    private void LoadControlsFromObject()
    {
        //populate dropdowns
        //TO DO : modify drop down population to add archived item if persisted in entity 
        //          and remove "-- Select a Value --" when an item is selected and field is not nullable 
        PopulateDropDowns();
        
        //Facility:
        LabelFacility.Text = "(" + referral.STD_INSTITUTION.STD_INSTITUTION_PARENT.NAME + ")" + "(" + referral.STD_INSTITUTION.STATIONNUMBER + ")" + "&nbsp;" + referral.STD_INSTITUTION.VISTANAME;
       
        //Name/SS# of Patient with + screen and desiring eval
        LabelPatientNameSnum.Text = referral.PATIENT.LAST_NAME + ",&nbsp;" + referral.PATIENT.FIRST_NAME 
            + "&nbsp;" + referral.PATIENT.MIDDLE_NAME + "&nbsp;-&nbsp;" + referral.PATIENT.Snum;

        //Date of Screening
        //TextBoxReferralDate.Text = Helpers.getShortDateStringFromNullableDate(referral.REFERRAL_DATE);
        LabelReferralDate.Text = Helpers.getShortDateStringFromNullableDate(referral.REFERRAL_DATE);

        //Date of Consult/Referral
        TextBoxDateConsultReferral.Text = Helpers.getShortDateStringFromNullableDate(referral.WKF_CASEs[0].TBI_TRACKINGs.FirstOrDefault().REFERRAL_SCHEDULE_DATE);
        //DateConsultReferral.DateValue = Helpers.getShortDateStringFromNullableDate(referral.WKF_CASEs[0].TBI_TRACKINGs.FirstOrDefault().REFERRAL_SCHEDULE_DATE);
        //PopCalendarTextBoxDateConsultReferral.From.Date = (DateTime)referral.REFERRAL_DATE;
        //DateConsultReferral.DateTimeFrom = ((DateTime)referral.REFERRAL_DATE).ToShortDateString();
        
        //PopCalendarTextBoxDateConsultReferral.RequiredDate = referral.TbiDateConsultReferralIsRequired;
        //RequiredFieldValidatorForTextBoxDateConsultReferral.Enabled = referral.TbiDateConsultReferralIsRequired;
        //DateConsultReferral.Required = referral.TbiDateConsultReferralIsRequired;
        
        CheckBoxNotApplicable.Checked = referral.WKF_CASEs[0].TBI_TRACKINGs[0].CONSULT_NOT_APPLICABLE_FLAG.GetValueOrDefault();
        
        //make the popup calendar disabled when not applicable box is checked
        //PopCalendarTextBoxDateConsultReferral.Enabled = !CheckBoxNotApplicable.Checked;
        RequiredFieldValidatorForTextBoxDateConsultReferral.Enabled = referral.TbiDateConsultReferralIsRequired;
        //DateConsultReferral.Required = referral.TbiDateConsultReferralIsRequired;
                
        //Other Consult Referral Status
        DropDownListOtherConsultStatus.SelectedValue = referral.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALSTS_ID.ToString();
        DropDownListOtherConsultStatus.Enabled = referral.WKF_CASEs[0].TBI_TRACKINGs[0].TbiOtherConsultStatusIsEditable;
        RequiredFieldValidatorDropDownListOtherConsultStatus.Enabled = referral.TbiOtherConsultStatusIsRequired;

        //RegularExpressionValidatorForDropDownListOtherConsultStatus.Enabled = referral.TbiItemIsInConsultNotSubmittedStatus;
        //Consult Not Submitted Notice Literal
        //LiteralConsultNotSubmittedNotice.Visible = referral.WKF_CASEs[0].TBI_TRACKINGs[0].TbiOtherConsultNotSubmittedNotice;
        //TableRowForConsultNotSubmittedNotice.Visible = referral.WKF_CASEs[0].TBI_TRACKINGs[0].TbiOtherConsultNotSubmittedNotice;
        //if (referral.WKF_CASEs[0].TBI_TRACKINGs[0].TbiOtherConsultNotSubmittedNotice)
        //{
        //    LiteralConsultNotSubmittedNotice.CssClass = "";
        //}
        //else
        //{
        //    LiteralConsultNotSubmittedNotice.CssClass = "displayNone";
        //}
         
        //Label Notice for multiple schedule attempts
        LabelDisplayNoticeForMultipleAttempts.Visible = ((referral.TbiNumberOfNoShows > 0) ? true : false);
        LabelNumberOfNoShows.Visible = ((referral.TbiNumberOfNoShows > 0) ? true : false);

        //First Schedule Attempt ----------------------------
        
        //Attempts to Contact Patient for Scheduling Purposes
        DropDownListAttempts.SelectedValue = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[0].STD_TBISCHEDULESTS_ID.ToString();
        RequiredFieldValidatorDropDownListAttempts.Enabled = referral.TbiAtemptsIsRequired;

        //Date Scheduled with TBI Evaluation Team
        TextBoxDateScheduledWithTBIEvaluationTeam.Text = Helpers.getShortDateStringFromNullableDate(referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.One].TBI_EVALUATION_SCHEDULE_DATE);
        //lblMsg1.Visible = referral.TbiDateScheduledWithTBIEvaluationTeamIsRequired;
        
        //PopCalendarDateScheduledWithTBIEvaluationTeam.RequiredDate = referral.TbiDateScheduledWithTBIEvaluationTeamIsRequired;
        //PopCalendarDateScheduledWithTBIEvaluationTeam.From.Date = (DateTime)referral.REFERRAL_DATE;
        RequiredFieldValidatorForTextBoxDateScheduledWithTBIEvaluationTeam.Enabled = referral.TbiDateScheduledWithTBIEvaluationTeamIsRequired;
        
        //Time to Scheduled Appointment with TBI Evaluation Team
        LabelTimeToScheduledAppointmentWithTBITeam.Text = Helpers.getStringFromNullableInt(referral.GetTimeScheduledAppointmentTBITeam((int)TBI_REFERRAL.Attempt.One));

        //Delay in Completing Evaluation
        DropDownListDelayCompletingEvaluation.SelectedValue = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.One].STD_TBIEVALDELAYTYPE_ID.ToString();
        RequiredFieldValidatorDropDownListDelayCompletingEvaluation.Enabled = referral.TbiDelayCompletingEvaluation;
        

        //Second Schedule Attempt ---------------------------
        if (referral.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() > 1)
        {
            //Attempts to Contact Patient for Scheduling Purposes
            DropDownListSecondContactAttempt.SelectedValue = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Two].STD_TBISCHEDULESTS_ID.ToString();
            RequiredFieldValidatorForDropDownListSecondContactAttempt.Enabled = referral.TbiAttempts2IsRequired;

            //Date Scheduled with TBI Evaluation Team
            TextBoxDateScheduledTBI1.Text = Helpers.getShortDateStringFromNullableDate(referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Two].TBI_EVALUATION_SCHEDULE_DATE);
            //PopCalendarSecondDateScheduledTBI.RequiredDate = referral.TbiSecondDateScheduledTBIIsRequired;
            RequiredFieldValidatorForTextBoxDateScheduledTBI1.Enabled = referral.TbiSecondDateScheduledIsRequired;
            //PopCalendarSecondDateScheduledTBI.From.Date = (DateTime)referral.REFERRAL_DATE;

            //Time to Scheduled Appointment with TBI Evaluation Team
            LabelTimeScheduledTBI1.Text = Helpers.getStringFromNullableInt(referral.GetTimeScheduledAppointmentTBITeam((int)TBI_REFERRAL.Attempt.Two));

            //Delay in Completing Evaluation
            DropDownListDelay1.SelectedValue = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Two].STD_TBIEVALDELAYTYPE_ID.ToString();
            RequiredFieldValidatorForDropDownListDelay1.Enabled = referral.TbiDelay2CompletingEvaluation;
        }
        else 
        {
            //Attempts to Contact Patient for Scheduling Purposes
            DropDownListSecondContactAttempt.SelectedValue = "";
            RequiredFieldValidatorForDropDownListSecondContactAttempt.Enabled = referral.TbiAttempts2IsRequired;

            //Date Scheduled with TBI Evaluation Team
            TextBoxDateScheduledTBI1.Text = "";
            //lblMsg3.Visible = referral.TbiPopCalendarSecondDateScheduledTBIIsRequired;
            RequiredFieldValidatorForTextBoxDateScheduledTBI1.Enabled = referral.TbiSecondDateScheduledIsRequired;
            //PopCalendarSecondDateScheduledTBI.RequiredDate = referral.TbiSecondDateScheduledTBIIsRequired;

            //Time to Scheduled Appointment with TBI Evaluation Team
            LabelTimeScheduledTBI1.Text = "";

            //Delay in Completing Evaluation
            DropDownListDelay1.SelectedValue = "";
            RequiredFieldValidatorForDropDownListDelay1.Enabled = referral.TbiDelay2CompletingEvaluation;
        }

        //Third Schedule Attempt ---------------------------
        if (referral.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() > 2)
        {

            //Attempts to Contact Patient for Scheduling Purposes
            DropDownListAttempts2.SelectedValue = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Three].STD_TBISCHEDULESTS_ID.ToString();
            RequiredFieldValidatorForDropDownListAttempts2.Enabled = referral.TbiAttempts3IsRequired;

            //Date Scheduled with TBI Evaluation Team
            TextBoxDateScheduledTBI2.Text = Helpers.getShortDateStringFromNullableDate(referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Three].TBI_EVALUATION_SCHEDULE_DATE);
            //PopCalendarThirdDateScheduledTBI.RequiredDate = referral.TbiThirdDateScheduledIsRequired;
            //PopCalendarThirdDateScheduledTBI.From.Date = (DateTime)referral.REFERRAL_DATE;
            RequiredFieldValidatorForTextBoxDateScheduledTBI2.Enabled = referral.TbiThirdDateScheduledIsRequired;

            //Time to Scheduled Appointment with TBI Evaluation Team
            LabelTimeScheduledTBI2.Text = Helpers.getStringFromNullableInt(referral.GetTimeScheduledAppointmentTBITeam((int)TBI_REFERRAL.Attempt.Three));

            //Delay in Completing Evaluation
            DropDownListDelay2.SelectedValue = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)TBI_REFERRAL.Attempt.Three].STD_TBIEVALDELAYTYPE_ID.ToString();
            RequiredFieldValidatorForDropDownListDelay2.Enabled = referral.TbiDelay3CompletingEvaluation;
        }
        else
        {
            //Attempts to Contact Patient for Scheduling Purposes
            DropDownListAttempts2.SelectedValue = "";
            RequiredFieldValidatorForDropDownListAttempts2.Enabled = referral.TbiAttempts3IsRequired;

            //Date Scheduled with TBI Evaluation Team
            TextBoxDateScheduledTBI2.Text = "";
            //lblMsg4.Visible = referral.TbiPopCalendar3IsRequired;
            RequiredFieldValidatorForTextBoxDateScheduledTBI2.Enabled = referral.TbiThirdDateScheduledIsRequired;
            //PopCalendarThirdDateScheduledTBI.RequiredDate = referral.TbiThirdDateScheduledIsRequired;

            //Time to Scheduled Appointment with TBI Evaluation Team
            LabelTimeScheduledTBI2.Text = "";

            //Delay in Completing Evaluation
            DropDownListDelay2.SelectedValue = "";
            RequiredFieldValidatorForDropDownListDelay2.Enabled = referral.TbiDelay3CompletingEvaluation;
        }

        //end attempts

        //Multiple Patient No Show/Cancellation
        LabelNumberOfNoShows.Text = referral.TbiNumberOfNoShows.ToString();

        //Date Evaluation Completed
        TextBoxDateEvaluationCompleted.Text = Helpers.getShortDateStringFromNullableDate(referral.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_COMPLETE_DATE);
        RequiredFieldValidatorForTextBoxDateEvaluationCompleted.Enabled = referral.TbiDateEvaluationCompletedIsRequired;


        //enable dropdowns 'Definitive TBI Diagnosis' and 'Responsible TBI Evaluation Team (Service/Clinic)'
        if (!string.IsNullOrEmpty(TextBoxDateEvaluationCompleted.Text))
        {
            DropDownListDefinitiveTBIDiagnosis.Enabled = true;
            DropDownListResponsibleTeam.Enabled = true;
        }
        else
        {
            DropDownListDefinitiveTBIDiagnosis.Enabled = false;
            DropDownListResponsibleTeam.Enabled = false;
        }

        //lblMsg2.Visible = referral.TbiEvaluationCompletedDateIsRequired;
        
        //Time to Complete Evaluation
        LabelTimeToCompleteEvaluation.Text = Helpers.getStringFromNullableInt(referral.GetTimeEvaluationCompleted());

        //Definitive TBI Diagnosis
        DropDownListDefinitiveTBIDiagnosis.SelectedValue = referral.WKF_CASEs[0].TBI_TRACKINGs[0].TBI_DIAGNOSIS_IND.ToString();
        RequiredFieldValidatorListDefinitiveTBIDiagnosis.Enabled = referral.TbiDefinitiveTBIDiagnosis;

        //Responsible TBI Evaluation Team (Service/Clinic)
        DropDownListResponsibleTeam.SelectedValue = referral.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBITEAMTYPE_ID.ToString();
        RequiredFieldValidatorResponsibleTeam.Enabled = referral.TbiResponsibleTeamIsRequired;

        //Responsible TBI Evaluation Team (Service/Clinic) Other
        TextBoxResponsibleTeamOther.Text = referral.WKF_CASEs[0].TBI_TRACKINGs[0].OTHER_TBI_FACILITY_DSCR;
        //TextBoxResponsibleTeamOther.Enabled = referral.TbiTeamTypeOtherIsEditable;
        RequiredFieldValidatorResponsibleTeamOther.Enabled = referral.TbiTeamTypeOtherIsRequired;

        //Status
        //DropDownListReferralStatus.DataSource = referral.AvailablevailableStatusList;
        //DropDownListReferralStatus.DataBind();
        //DropDownListReferralStatus.SelectedValue = referral.STD_REFERRALSTS_ID.ToString();
        LabelReferralStatus.Text = referral.STD_REFERRALST.NAME.ToString();

        if (referral.STD_REFERRALSTS_ID == (int)TBI_REFERRAL.TbiReferralStatus.Completed)
        {
            ButtonComplete.Visible = false;
            ButtonReOpen.Visible = true;
            ButtonSave.Enabled = false;
            this.ReadOnly = true;
        }
        else
        {
            ButtonComplete.Visible = true;
            ButtonReOpen.Visible = false;
            ButtonSave.Enabled = true;
        }
        //set the enabled status of items in the status dropdown

        //foreach (ListItem l in DropDownListReferralStatus.Items)
        //{
        //    bool someResult;
        //    int statusId = Helpers.getIntFromString(l.Value);
        //    bool someVal = bool.TryParse(referral.AvailableStatusList[statusId].ToString(), out someResult);

        //    l.Enabled = someResult;

        //}

        //if (this.ReadOnly)
        //{
        //    DropDownListReferralStatus.Enabled = false;
           
        //}
        //else
        //{
        //    DropDownListReferralStatus.Enabled = referral.TbiReferralStatusIsEditable;
        //}
        
        //Set Broken Rule Error Display
        if (referral.BrokenRules.Count > 0 && HiddenFieldDisplaySaveErrorList.Value == "true")
        { 
            ErrorList1.Visible = true; 
        }
        else 
        {
            ErrorList1.Visible = false;
        }

        ErrorList1.BrokenRules = referral.BrokenRules;


        //Set display of 2nd and 3rd attempts
        if (referral.TbiNumberOfNoShows >= 2 || referral.TbiAttempts3IsRequired)
        {
            att1.Visible = true;
            att3.Visible = true;
            att5.Visible = true;
            att7.Visible = true;
            att9.Visible = true;
            att11.Visible = true;
            att13.Visible = true;
            att15.Visible = true;
            att16.Visible = true;
        }
        else if (referral.TbiNumberOfNoShows == 1 || referral.TbiAttempts2IsRequired)
        {
            att1.Visible = true;
            att3.Visible = true;
            att5.Visible = true;
            att7.Visible = true;
            att9.Visible = false;
            att11.Visible = false;
            att13.Visible = false;
            att15.Visible = false;
            att16.Visible = false;
        }
        else
        {
            att1.Visible = false;
            att3.Visible = false;
            att5.Visible = false;
            att7.Visible = false;
            att9.Visible = false;
            att11.Visible = false;
            att13.Visible = false;
            att15.Visible = false;
            att16.Visible = false;
        }

        SetDateValidators();
    }

    private void SetDateValidators()
    {
        RangeValidatorTextBoxDateConsultReferral.MinimumValue = LabelReferralDate.Text;//Date of Screening
        RangeValidatorTextBoxDateConsultReferral.MaximumValue = DateTime.Today.ToShortDateString();
        CompareValidatorTextBoxDateScheduledWithTBIEvaluationTeamMin.ValueToCompare = LabelReferralDate.Text;

        RangeValidatorTextBoxDateEvaluationCompleted.MinimumValue = LabelReferralDate.Text;
        RangeValidatorTextBoxDateEvaluationCompleted.MaximumValue = DateTime.Today.ToShortDateString();
    }
    
    private void PopulateDropDowns()
    {

        if (DropDownListOtherConsultStatus.Items.Count == 1)
        {
            DropDownListOtherConsultStatus.DataBind();
        }

        if (DropDownListAttempts.Items.Count == 1)
        {
            DropDownListAttempts.DataBind();
        }

        if (DropDownListDelayCompletingEvaluation.Items.Count == 1)
        {
            DropDownListDelayCompletingEvaluation.DataBind();
        }

        if (DropDownListSecondContactAttempt.Items.Count == 1)
        {
            DropDownListSecondContactAttempt.DataBind();
        }

        if (DropDownListDelay1.Items.Count == 1)
        {
            DropDownListDelay1.DataBind();
        }

        if (DropDownListAttempts2.Items.Count == 1)
        {
            DropDownListAttempts2.DataBind();
        }

        if (DropDownListDelay2.Items.Count == 1)
        {
            DropDownListDelay2.DataBind();
        }

        if (DropDownListDefinitiveTBIDiagnosis.Items.Count == 1)
        {
            DropDownListDefinitiveTBIDiagnosis.DataBind();
        }

        if (DropDownListResponsibleTeam.Items.Count == 1)
        {
            DropDownListResponsibleTeam.DataBind();
        }

        //if (DropDownListReferralStatus.Items.Count == 1)
        //{
        //    DropDownListReferralStatus.DataBind();
        //}

        
    }
    #endregion 
    //public string getTitleCaseFromString(string inString)
    //{
    //    CultureInfo cultureInfo = Thread.CurrentThread.CurrentCulture;
    //    TextInfo textInfo = cultureInfo.TextInfo;

    //    return textInfo.ToTitleCase(inString);


    //}
    
   
}